/// <reference path="./internal_*.d.ts" />
declare namespace com.illusivesoulworks.polymorph.mixin.core {
    interface AccessorSmithingTransformRecipe {
        abstract getTemplate(): Internal.Ingredient;
        abstract getBase(): Internal.Ingredient;
        abstract getAddition(): Internal.Ingredient;
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get addition(): Internal.Ingredient
    }
    type AccessorSmithingTransformRecipe_ = AccessorSmithingTransformRecipe;
}
declare namespace Internal {
    abstract class BufferStrategy {
        abstract getCapabilities(): Internal.BufferCapabilities;
        abstract contentsRestored(): boolean;
        dispose(): void;
        abstract show(): void;
        abstract contentsLost(): boolean;
        abstract getDrawGraphics(): Internal.Graphics;
        get capabilities(): Internal.BufferCapabilities
        get drawGraphics(): Internal.Graphics
    }
    type BufferStrategy_ = BufferStrategy;
    interface ParticleManagerAccessor {
        abstract getFactories(): Internal.Int2ObjectMap<Internal.ParticleProvider<any>>;
        abstract getSpriteAwareFactories(): Internal.Map<ResourceLocation, Internal.SpriteSet>;
        abstract getParticleAtlasTexture(): Internal.TextureAtlas;
        get factories(): Internal.Int2ObjectMap<Internal.ParticleProvider<any>>
        get spriteAwareFactories(): Internal.Map<ResourceLocation, Internal.SpriteSet>
        get particleAtlasTexture(): Internal.TextureAtlas
    }
    type ParticleManagerAccessor_ = ParticleManagerAccessor;
    class Dynamic <T> extends Internal.DynamicLike<T> {
        constructor(arg0: Internal.DynamicOps_<T>, arg1: T)
        constructor(arg0: Internal.DynamicOps_<T>)
        convert<R>(arg0: Internal.DynamicOps_<R>): Internal.Dynamic<R>;
        updateGeneric(arg0: T, arg1: Internal.Function_<T, T>): this;
        getElementGeneric(arg0: T): Internal.DataResult<T>;
        updateMapValues(arg0: Internal.Function_<com.mojang.datafixers.util.Pair<Internal.Dynamic<any>, Internal.Dynamic<any>>, com.mojang.datafixers.util.Pair<Internal.Dynamic<any>, Internal.Dynamic<any>>>): this;
        remove(arg0: string): this;
        set(arg0: string, arg1: Internal.Dynamic_<any>): this;
        getGeneric(arg0: T): Internal.DataResult<T>;
        merge(arg0: Internal.Dynamic_<any>, arg1: Internal.Dynamic_<any>): Internal.OptionalDynamic<T>;
        cast<U>(arg0: Internal.DynamicOps_<U>): U;
        static convert<S, T>(arg0: Internal.DynamicOps_<S>, arg1: Internal.DynamicOps_<T>, arg2: S): T;
        getMapValues(): Internal.DataResult<Internal.Map<Internal.Dynamic<T>, Internal.Dynamic<T>>>;
        update(arg0: string, arg1: Internal.Function_<Internal.Dynamic<any>, Internal.Dynamic<any>>): this;
        merge(arg0: Internal.Dynamic_<any>): Internal.OptionalDynamic<T>;
        map(arg0: Internal.Function_<T, T>): this;
        asStreamOpt(): Internal.DataResult<Internal.Stream<Internal.Dynamic<T>>>;
        castTyped<U>(arg0: Internal.DynamicOps_<U>): Internal.Dynamic<U>;
        getValue(): T;
        getElement(arg0: string): Internal.DataResult<T>;
        asMapOpt(): Internal.DataResult<Internal.Stream<com.mojang.datafixers.util.Pair<Internal.Dynamic<T>, Internal.Dynamic<T>>>>;
        decode<A>(arg0: Internal.Decoder_<A>): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        into<V>(arg0: Internal.Function_<Internal.Dynamic<T>, V>): V;
        get(arg0: string): Internal.OptionalDynamic<T>;
        get mapValues(): Internal.DataResult<Internal.Map<Internal.Dynamic<T>, Internal.Dynamic<T>>>
        get value(): T
    }
    type Dynamic_<T> = Dynamic<T>;
    class ControllerRailBlock extends Internal.BaseRailBlock implements Internal.MinecartPassHandlerBlock, com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        onMinecartPass(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, cart: Internal.AbstractMinecart_): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        static isStateBackwards(state: Internal.BlockState_): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static getAccelerationVector(state: Internal.BlockState_): Vec3i;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        static isReversedSlope(state: Internal.BlockState_): boolean;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly BACKWARDS: Internal.BooleanProperty;
        static readonly SHAPE: Internal.EnumProperty<Internal.RailShape>;
        static readonly POWER: Internal.IntegerProperty;
    }
    type ControllerRailBlock_ = ControllerRailBlock;
    interface ObjectIterable <K> extends Internal.Iterable<K> {
        iterator(): Internal.Iterator<any>;
        forEach(arg0: Internal.Consumer_<K>): void;
        spliterator(): Internal.ObjectSpliterator<K>;
    }
    type ObjectIterable_<K> = ObjectIterable<K>;
    class KeyboardPeripheral implements Internal.IPeripheral {
        constructor(kbTile: Internal.KeyboardTile_)
        sendKeyUp(key: number): void;
        sendTerminate(): void;
        attach(computer: Internal.IComputerAccess_): void;
        equals(other: Internal.IPeripheral_): boolean;
        sendShutdown(): void;
        sendKey(key: number, repeat: boolean): void;
        detach(computer: Internal.IComputerAccess_): void;
        sendPaste(text: string): void;
        sendReboot(): void;
        getAdditionalTypes(): Internal.Set<string>;
        getType(): string;
        sendChar(c: string): void;
        getTarget(): any;
        get additionalTypes(): Internal.Set<string>
        get type(): string
        get target(): any
        computers: Internal.List<Internal.IComputerAccess>;
    }
    type KeyboardPeripheral_ = KeyboardPeripheral;
    class SafeBlockGetter implements Internal.BlockGetter {
        constructor(wrapped: Internal.ServerLevel_)
        getMinSection(): number;
        getBlockState(pos: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        getHeight(): number;
        getBlockEntity(pos: BlockPos_): Internal.BlockEntity;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getFluidState(pos: BlockPos_): Internal.FluidState;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        shouldUse(): boolean;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get height(): number
        get minBuildHeight(): number
        get sectionsCount(): number
        get maxLightLevel(): number
    }
    type SafeBlockGetter_ = SafeBlockGetter;
    interface DoubleStream extends Internal.BaseStream<number, Internal.DoubleStream> {
        builder(): Internal.DoubleStream$Builder;
        abstract iterator(): Internal.PrimitiveIterator$OfDouble;
        iterate(arg0: number, arg1: Internal.DoubleUnaryOperator_): this;
        abstract unordered(): this;
        abstract mapToObj<U>(arg0: Internal.DoubleFunction_<U>): Internal.Stream<U>;
        abstract min(): Internal.OptionalDouble;
        abstract limit(arg0: number): this;
        abstract skip(arg0: number): this;
        abstract reduce(arg0: Internal.DoubleBinaryOperator_): Internal.OptionalDouble;
        concat(arg0: Internal.DoubleStream_, arg1: Internal.DoubleStream_): this;
        iterate(arg0: number, arg1: Internal.DoublePredicate_, arg2: Internal.DoubleUnaryOperator_): this;
        abstract summaryStatistics(): Internal.DoubleSummaryStatistics;
        abstract flatMap(arg0: Internal.DoubleFunction_<Internal.DoubleStream>): this;
        abstract isParallel(): boolean;
        abstract max(): Internal.OptionalDouble;
        abstract noneMatch(arg0: Internal.DoublePredicate_): boolean;
        abstract reduce(arg0: number, arg1: Internal.DoubleBinaryOperator_): number;
        abstract allMatch(arg0: Internal.DoublePredicate_): boolean;
        sequential(): Internal.BaseStream<any, any>;
        of(arg0: number): this;
        of(...arg0: number[]): this;
        abstract count(): number;
        abstract mapToLong(arg0: Internal.DoubleToLongFunction_): Internal.LongStream;
        abstract peek(arg0: Internal.DoubleConsumer_): this;
        abstract onClose(arg0: Internal.Runnable_): this;
        abstract toArray(): number[];
        abstract parallel(): this;
        abstract distinct(): this;
        abstract boxed(): Internal.Stream<number>;
        abstract map(arg0: Internal.DoubleUnaryOperator_): this;
        empty(): this;
        abstract forEachOrdered(arg0: Internal.DoubleConsumer_): void;
        abstract anyMatch(arg0: Internal.DoublePredicate_): boolean;
        abstract filter(arg0: Internal.DoublePredicate_): this;
        abstract findAny(): Internal.OptionalDouble;
        dropWhile(arg0: Internal.DoublePredicate_): this;
        generate(arg0: Internal.DoubleSupplier_): this;
        abstract mapToInt(arg0: Internal.DoubleToIntFunction_): Internal.IntStream;
        spliterator(): Internal.Spliterator<any>;
        mapMulti(arg0: Internal.DoubleStream$DoubleMapMultiConsumer_): this;
        takeWhile(arg0: Internal.DoublePredicate_): this;
        abstract forEach(arg0: Internal.DoubleConsumer_): void;
        abstract findFirst(): Internal.OptionalDouble;
        abstract close(): void;
        abstract sum(): number;
        abstract sorted(): this;
        abstract average(): Internal.OptionalDouble;
        abstract collect<R>(arg0: Internal.Supplier_<R>, arg1: Internal.ObjDoubleConsumer_<R>, arg2: Internal.BiConsumer_<R, R>): R;
        get parallel(): boolean
    }
    type DoubleStream_ = DoubleStream;
    abstract class BundlePacket <T extends Internal.PacketListener> implements Internal.Packet<T> {
        subPackets(): Internal.Iterable<Internal.Packet<T>>;
        write($$0: Internal.FriendlyByteBuf_): void;
        isSkippable(): boolean;
        abstract handle(arg0: T): void;
        get skippable(): boolean
    }
    type BundlePacket_<T extends Internal.PacketListener> = BundlePacket<T>;
    class TwistingVinesPlantBlock extends Internal.GrowingPlantBodyBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly SHAPE: Internal.VoxelShapeAlignedCuboid;
    }
    type TwistingVinesPlantBlock_ = TwistingVinesPlantBlock;
    interface PoiTypeAccessor {
        abstract setMatchingStates(arg0: Internal.Set_<any>): void;
        set matchingStates(arg0: Internal.Set_<any>)
        (arg0: Internal.Set<any>): void;
    }
    type PoiTypeAccessor_ = PoiTypeAccessor;
    interface App2 <F extends Internal.K2, A, B> {
    }
    type App2_<F extends Internal.K2, A, B> = App2<F, A, B>;
    class LocalDate implements Internal.Temporal, Internal.TemporalAdjuster, Internal.ChronoLocalDate, Internal.Serializable {
        datesUntil(arg0: Internal.LocalDate_, arg1: Internal.Period_): Internal.Stream<Internal.LocalDate>;
        static now(): Internal.LocalDate;
        static of(arg0: number, arg1: number, arg2: number): Internal.LocalDate;
        getMonth(): Internal.Month;
        plusMonths(arg0: number): this;
        static from(arg0: Internal.TemporalAccessor_): Internal.LocalDate;
        "with"(arg0: Internal.TemporalField_, arg1: number): this;
        isAfter(arg0: Internal.ChronoLocalDate_): boolean;
        toEpochSecond(arg0: Internal.LocalTime_, arg1: Internal.ZoneOffset_): number;
        getDayOfWeek(): Internal.DayOfWeek;
        atTime(arg0: Internal.OffsetTime_): Internal.OffsetDateTime;
        compareTo(arg0: any): number;
        atTime(arg0: number, arg1: number): Internal.LocalDateTime;
        getDayOfMonth(): number;
        static ofInstant(arg0: Internal.Instant_, arg1: Internal.ZoneId_): Internal.LocalDate;
        datesUntil(arg0: Internal.LocalDate_): Internal.Stream<Internal.LocalDate>;
        "with"(arg0: Internal.TemporalAdjuster_): this;
        atStartOfDay(): Internal.LocalDateTime;
        isSupported(arg0: Internal.TemporalField_): boolean;
        format(arg0: Internal.DateTimeFormatter_): string;
        toEpochDay(): number;
        getChronology(): Internal.Chronology;
        plusWeeks(arg0: number): this;
        withDayOfYear(arg0: number): this;
        static ofYearDay(arg0: number, arg1: number): Internal.LocalDate;
        static timeLineOrder(): Internal.Comparator<Internal.ChronoLocalDate>;
        withMonth(arg0: number): this;
        getYear(): number;
        compareTo(arg0: Internal.ChronoLocalDate_): number;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        atTime(arg0: Internal.LocalTime_): Internal.ChronoLocalDateTime<any>;
        atStartOfDay(arg0: Internal.ZoneId_): Internal.ZonedDateTime;
        get(arg0: Internal.TemporalField_): number;
        withDayOfMonth(arg0: number): this;
        minusYears(arg0: number): this;
        isBefore(arg0: Internal.ChronoLocalDate_): boolean;
        static parse(arg0: Internal.CharSequence_): Internal.LocalDate;
        static now(arg0: Internal.Clock_): Internal.LocalDate;
        getMonthValue(): number;
        minusDays(arg0: number): this;
        lengthOfYear(): number;
        plus(arg0: Internal.TemporalAmount_): Internal.ChronoLocalDate;
        getEra(): Internal.Era;
        plusDays(arg0: number): this;
        atTime(arg0: number, arg1: number, arg2: number): Internal.LocalDateTime;
        minus(arg0: number, arg1: Internal.TemporalUnit_): this;
        getLong(arg0: Internal.TemporalField_): number;
        static ofEpochDay(arg0: number): Internal.LocalDate;
        minusWeeks(arg0: number): this;
        withYear(arg0: number): this;
        atTime(arg0: number, arg1: number, arg2: number, arg3: number): Internal.LocalDateTime;
        static parse(arg0: Internal.CharSequence_, arg1: Internal.DateTimeFormatter_): Internal.LocalDate;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        plusYears(arg0: number): this;
        minusMonths(arg0: number): this;
        getDayOfYear(): number;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        plus(arg0: number, arg1: Internal.TemporalUnit_): Internal.ChronoLocalDate;
        isEqual(arg0: Internal.ChronoLocalDate_): boolean;
        static of(arg0: number, arg1: Internal.Month_, arg2: number): Internal.LocalDate;
        static now(arg0: Internal.ZoneId_): Internal.LocalDate;
        until(arg0: Internal.ChronoLocalDate_): Internal.Period;
        lengthOfMonth(): number;
        minus(arg0: Internal.TemporalAmount_): Internal.Temporal;
        isLeapYear(): boolean;
        get month(): Internal.Month
        get dayOfWeek(): Internal.DayOfWeek
        get dayOfMonth(): number
        get chronology(): Internal.Chronology
        get year(): number
        get monthValue(): number
        get era(): Internal.Era
        get dayOfYear(): number
        get leapYear(): boolean
        static readonly MIN: Internal.LocalDate;
        static readonly EPOCH: Internal.LocalDate;
        static readonly MAX: Internal.LocalDate;
    }
    type LocalDate_ = LocalDate;
    class CuckooClockBlock extends Internal.HorizontalKineticBlock implements Internal.IBE<Internal.CuckooClockBlockEntity> {
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CuckooClockBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntityClass(): typeof Internal.CuckooClockBlockEntity;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static mysterious(properties: Internal.BlockBehaviour$Properties_): Internal.CuckooClockBlock;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        static regular(properties: Internal.BlockBehaviour$Properties_): Internal.CuckooClockBlock;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CuckooClockBlockEntity>;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.CuckooClockBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CuckooClockBlockEntity>): void;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CuckooClockBlockEntity;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static containsSurprise(state: Internal.BlockState_): boolean;
        get blockEntityClass(): typeof Internal.CuckooClockBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.CuckooClockBlockEntity>
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type CuckooClockBlock_ = CuckooClockBlock;
    class HugeLilyPadFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type HugeLilyPadFeature_ = HugeLilyPadFeature;
    class EndGatewayFeature extends Internal.Feature<Internal.EndGatewayConfiguration> {
        constructor($$0: Internal.Codec_<Internal.EndGatewayConfiguration>)
    }
    type EndGatewayFeature_ = EndGatewayFeature;
    interface FeatureConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly NONE: Internal.NoneFeatureConfiguration;
    }
    type FeatureConfiguration_ = FeatureConfiguration;
    interface BufferBuilderExt {
        abstract splitStrip(): void;
        (): void;
    }
    type BufferBuilderExt_ = BufferBuilderExt;
    class DynamicTexture extends Internal.AbstractTexture implements Internal.Dumpable {
        constructor($$0: Internal.NativeImage_)
        constructor($$0: number, $$1: number, $$2: boolean)
        getPixels(): Internal.NativeImage;
        upload(): void;
        dumpContents(pResourceLocation: ResourceLocation_, pPath: Internal.Path_): void;
        wrapOperation$ffn000$moonlight$forceMipMap(a: number, b: number, c: number, op: Internal.Operation_<any>): void;
        wrapOperation$ffn000$moonlight$forceMipMap(instance: Internal.NativeImage_, a: number, b: number, c: number, autoClose: boolean, op: Internal.Operation_<any>): void;
        setPixels($$0: Internal.NativeImage_): void;
        get pixels(): Internal.NativeImage
        set pixels($$0: Internal.NativeImage_)
    }
    type DynamicTexture_ = DynamicTexture;
    abstract class AbstractDocument <T extends Internal.AbstractDocument<T>> extends Internal.AbstractDocumentBase<T> {
        constructor()
        getMergedComment(): Internal.PropertyComment;
        get mergedComment(): Internal.PropertyComment
    }
    type AbstractDocument_<T extends Internal.AbstractDocument<T>> = AbstractDocument<T>;
    class CustomInstructionKeyframeEvent <T extends Internal.GeoAnimatable> extends Internal.KeyFrameEvent<T, Internal.CustomInstructionKeyframeData> {
        constructor(entity: T, animationTick: number, controller: Internal.AnimationController_<T>, customInstructionKeyframeData: Internal.CustomInstructionKeyframeData_)
        getKeyframeData(): Internal.CustomInstructionKeyframeData;
        get keyframeData(): Internal.CustomInstructionKeyframeData
    }
    type CustomInstructionKeyframeEvent_<T extends Internal.GeoAnimatable> = CustomInstructionKeyframeEvent<T>;
    class FabricItemRelay extends Internal.ItemRelay implements Internal.GeoItem {
        constructor(properties: Internal.Item$Properties_)
        stopTriggeredArmorAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        getTick(itemStack: any): number;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        syncAnimData<D>(instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>, data: D, entityToTrack: Internal.Entity_): void;
        setAttackSpeed(attackSpeed: number): void;
        isPerspectiveAware(): boolean;
        triggerAnim<D>(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getCreativeTab(): string;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setAnimData<D>(relatedEntity: Internal.Entity_, instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>, data: D): void;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        triggerAnim(instanceId: number, controllerName: string, animName: string, packetCallback: Internal.GeckoLibNetwork$IPacketCallback_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        static registerSyncedAnimatable(animatable: Internal.GeoAnimatable_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getBoneResetTime(): number;
        triggerArmorAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getAnimData<D>(instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>): D;
        shouldPlayAnimsWhileGamePaused(): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static getId(stack: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getOrAssignId(stack: Internal.ItemStack_, level: Internal.ServerLevel_): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        static makeRenderer(item: Internal.GeoItem_): Internal.Supplier<any>;
        stopTriggeredAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get perspectiveAware(): boolean
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        get boneResetTime(): number
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type FabricItemRelay_ = FabricItemRelay;
    interface SharedSuggestionProvider {
        getSelectedEntities(): Internal.Collection<string>;
        suggestCoordinates($$0: string, $$1: Internal.Collection_<Internal.SharedSuggestionProvider$TextCoordinates>, $$2: Internal.SuggestionsBuilder_, $$3: Internal.Predicate_<string>): Internal.CompletableFuture<Internal.Suggestions>;
        suggestResource($$0: Internal.Stream_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggest($$0: Internal.Stream_<string>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggest($$0: string[], $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        abstract hasPermission(arg0: number): boolean;
        suggestResource<T>($$0: Internal.Iterable_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        getCustomTabSugggestions(): Internal.Collection<string>;
        abstract getRecipeNames(): Internal.Stream<ResourceLocation>;
        suggestResource($$0: Internal.Stream_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_, $$2: string): Internal.CompletableFuture<Internal.Suggestions>;
        filterResources<T>($$0: Internal.Iterable_<T>, $$1: string, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Consumer_<T>): void;
        matchesSubStr($$0: string, $$1: string): boolean;
        suggest2DCoordinates($$0: string, $$1: Internal.Collection_<Internal.SharedSuggestionProvider$TextCoordinates>, $$2: Internal.SuggestionsBuilder_, $$3: Internal.Predicate_<string>): Internal.CompletableFuture<Internal.Suggestions>;
        suggest<T>($$0: Internal.Iterable_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, string>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        abstract customSuggestion(arg0: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        suggestResource($$0: Internal.Iterable_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggest($$0: Internal.Iterable_<string>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggestRegistryElements($$0: Internal.Registry_<any>, $$1: Internal.SharedSuggestionProvider$ElementSuggestionType_, $$2: Internal.SuggestionsBuilder_): void;
        abstract getAvailableSounds(): Internal.Stream<ResourceLocation>;
        abstract enabledFeatures(): Internal.FeatureFlagSet;
        abstract suggestRegistryElements(arg0: Internal.ResourceKey_<Internal.Registry<any>>, arg1: Internal.SharedSuggestionProvider$ElementSuggestionType_, arg2: Internal.SuggestionsBuilder_, arg3: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        abstract getAllTeams(): Internal.Collection<string>;
        filterResources<T>($$0: Internal.Iterable_<T>, $$1: string, $$2: string, $$3: Internal.Function_<T, ResourceLocation>, $$4: Internal.Consumer_<T>): void;
        abstract registryAccess(): Internal.RegistryAccess;
        getRelevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        getAbsoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        suggestResource($$0: Internal.Iterable_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_, $$2: string): Internal.CompletableFuture<Internal.Suggestions>;
        abstract levels(): Internal.Set<Internal.ResourceKey<Internal.Level>>;
        abstract getOnlinePlayerNames(): Internal.Collection<string>;
        suggestResource<T>($$0: Internal.Stream_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        get selectedEntities(): Internal.Collection<string>
        get customTabSugggestions(): Internal.Collection<string>
        get recipeNames(): Internal.Stream<ResourceLocation>
        get availableSounds(): Internal.Stream<ResourceLocation>
        get allTeams(): Internal.Collection<string>
        get relevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>
        get absoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>
        get onlinePlayerNames(): Internal.Collection<string>
    }
    type SharedSuggestionProvider_ = SharedSuggestionProvider;
    interface IMultiTileEnergyContainer extends Internal.IMultiBlockEntityContainer {
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        abstract getMaxWidth(): number;
        abstract removeController(arg0: boolean): void;
        abstract getControllerBE<T extends Internal.BlockEntity & Internal.IMultiBlockEntityContainer>(): T;
        abstract getWidth(): number;
        abstract isController(): boolean;
        abstract setController(arg0: BlockPos_): void;
        setExtraData(data: any): void;
        modifyExtraData(data: any): any;
        abstract getController(): BlockPos;
        abstract getLastKnownPos(): BlockPos;
        abstract preventConnectivityUpdate(): void;
        abstract notifyMultiUpdated(): void;
        getExtraData(): any;
        abstract getMainConnectionAxis(): Internal.Direction$Axis;
        abstract setHeight(arg0: number): void;
        abstract setWidth(arg0: number): void;
        abstract getHeight(): number;
        abstract getMaxLength(arg0: Internal.Direction$Axis_, arg1: number): number;
        get maxWidth(): number
        get controllerBE(): T
        get width(): number
        get controller(): boolean
        set controller(arg0: BlockPos_)
        set extraData(data: any)
        get controller(): BlockPos
        get lastKnownPos(): BlockPos
        get extraData(): any
        get mainConnectionAxis(): Internal.Direction$Axis
        set height(arg0: number)
        set width(arg0: number)
        get height(): number
    }
    type IMultiTileEnergyContainer_ = IMultiTileEnergyContainer;
    class OptionalDouble {
        stream(): Internal.DoubleStream;
        isPresent(): boolean;
        orElse(arg0: number): number;
        orElseThrow<X extends Internal.Throwable>(arg0: Internal.Supplier_<X>): number;
        static empty(): Internal.OptionalDouble;
        orElseGet(arg0: Internal.DoubleSupplier_): number;
        ifPresent(arg0: Internal.DoubleConsumer_): void;
        isEmpty(): boolean;
        getAsDouble(): number;
        static of(arg0: number): Internal.OptionalDouble;
        orElseThrow(): number;
        ifPresentOrElse(arg0: Internal.DoubleConsumer_, arg1: Internal.Runnable_): void;
        get present(): boolean
        get empty(): boolean
        get asDouble(): number
    }
    type OptionalDouble_ = OptionalDouble;
    abstract class AsynchronousFileChannel implements Internal.AsynchronousChannel {
        lock<A>(arg0: A, arg1: Internal.CompletionHandler_<Internal.FileLock, A>): void;
        static open(arg0: Internal.Path_, arg1: Internal.Set_<Internal.OpenOption>, arg2: Internal.ExecutorService_, ...arg3: any_<any>[]): Internal.AsynchronousFileChannel;
        tryLock(): Internal.FileLock;
        abstract size(): number;
        abstract read<A>(arg0: Internal.ByteBuffer_, arg1: number, arg2: A, arg3: Internal.CompletionHandler_<number, A>): void;
        abstract write(arg0: Internal.ByteBuffer_, arg1: number): Internal.Future<number>;
        abstract lock(arg0: number, arg1: number, arg2: boolean): Internal.Future<Internal.FileLock>;
        abstract read(arg0: Internal.ByteBuffer_, arg1: number): Internal.Future<number>;
        abstract lock<A>(arg0: number, arg1: number, arg2: boolean, arg3: A, arg4: Internal.CompletionHandler_<Internal.FileLock, A>): void;
        abstract write<A>(arg0: Internal.ByteBuffer_, arg1: number, arg2: A, arg3: Internal.CompletionHandler_<number, A>): void;
        abstract isOpen(): boolean;
        lock(): Internal.Future<Internal.FileLock>;
        static open(arg0: Internal.Path_, ...arg1: Internal.OpenOption_[]): Internal.AsynchronousFileChannel;
        abstract close(): void;
        abstract tryLock(arg0: number, arg1: number, arg2: boolean): Internal.FileLock;
        abstract truncate(arg0: number): this;
        abstract force(arg0: boolean): void;
        get open(): boolean
    }
    type AsynchronousFileChannel_ = AsynchronousFileChannel;
    interface TravellingPoint$IEdgePointListener extends Internal.BiPredicate<number, net.createmod.catnip.data.Pair<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>> {
        or(arg0: Internal.BiPredicate_<number, net.createmod.catnip.data.Pair<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>>): Internal.BiPredicate<number, net.createmod.catnip.data.Pair<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>>;
        abstract test(arg0: number, arg1: net.createmod.catnip.data.Pair_<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>): boolean;
        negate(): Internal.BiPredicate<number, net.createmod.catnip.data.Pair<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>>;
        and(arg0: Internal.BiPredicate_<number, net.createmod.catnip.data.Pair<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>>): Internal.BiPredicate<number, net.createmod.catnip.data.Pair<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>>;
        (arg0: number, arg1: net.createmod.catnip.data.Pair<Internal.TrackEdgePoint, Internal.Couple<Internal.TrackNode>>): boolean;
    }
    type TravellingPoint$IEdgePointListener_ = TravellingPoint$IEdgePointListener;
    class FriendlyByteBuf extends Internal.ByteBuf {
        constructor($$0: Internal.ByteBuf_)
        writeEither<L, R>($$0: Internal.Either_<L, R>, $$1: Internal.FriendlyByteBuf$Writer_<L>, $$2: Internal.FriendlyByteBuf$Writer_<R>): void;
        writeUtf($$0: string, $$1: number): this;
        writeUtf($$0: string): this;
        readInstant(): Internal.Instant;
        readVarInt(): number;
        writeFixedBitSet($$0: Internal.BitSet_, $$1: number): void;
        writeVarLong($$0: number): this;
        readQuaternion(): Quaternionf;
        writeItem($$0: Internal.ItemStack_): this;
        readPublicKey(): Internal.PublicKey;
        readBlockHitResult(): Internal.BlockHitResult;
        readDate(): Internal.Date;
        readLongArray(): number[];
        readResourceKey<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.ResourceKey<T>;
        writeNullable<T>($$0: T, $$1: Internal.FriendlyByteBuf$Writer_<T>): void;
        readMap<K, V>($$0: Internal.FriendlyByteBuf$Reader_<K>, $$1: Internal.FriendlyByteBuf$Reader_<V>): Internal.Map<K, V>;
        writeNbt($$0: Internal.CompoundTag_): this;
        readEnum<T extends Internal.Enum<T>>($$0: T): T;
        retain(arg0: number): Internal.ReferenceCounted;
        touch(arg0: any): Internal.ReferenceCounted;
        readAnySizeNbt(): Internal.CompoundTag;
        /**
         * @deprecated
        */
        writeWithCodec<T>($$0: Internal.DynamicOps_<Internal.Tag>, $$1: Internal.Codec_<T>, $$2: T): void;
        writeOptional<T>($$0: Internal.Optional_<T>, $$1: Internal.FriendlyByteBuf$Writer_<T>): void;
        writeDate($$0: Internal.Date_): this;
        writeProperty($$0: com.mojang.authlib.properties.Property_): void;
        readGlobalPos(): Internal.GlobalPos;
        readChunkPos(): Internal.ChunkPos;
        writeResourceLocation($$0: ResourceLocation_): this;
        readEither<L, R>($$0: Internal.FriendlyByteBuf$Reader_<L>, $$1: Internal.FriendlyByteBuf$Reader_<R>): Internal.Either<L, R>;
        writeInstant($$0: Internal.Instant_): void;
        writeUUID($$0: Internal.UUID_): this;
        writeVector3f($$0: Vec3f_): void;
        writeByteArray($$0: number[]): this;
        readVarIntArray($$0: number): number[];
        writeId<T>($$0: Internal.IdMap_<Internal.Holder<T>>, $$1: Internal.Holder_<T>, $$2: Internal.FriendlyByteBuf$Writer_<T>): void;
        readByteArray(): number[];
        writeCollection<T>($$0: Internal.Collection_<T>, $$1: Internal.FriendlyByteBuf$Writer_<T>): void;
        readLongArray($$0: number[]): number[];
        readBlockPos(): BlockPos;
        readVarLong(): number;
        writeJsonWithCodec<T>($$0: Internal.Codec_<T>, $$1: T): void;
        retain(): Internal.ReferenceCounted;
        static getVarLongSize($$0: number): number;
        readJsonWithCodec<T>($$0: Internal.Codec_<T>): T;
        writeChunkPos($$0: Internal.ChunkPos_): this;
        readLongArray($$0: number[], $$1: number): number[];
        writeLongArray($$0: number[]): this;
        readResourceLocation(): ResourceLocation;
        readNbt($$0: Internal.NbtAccounter_): Internal.CompoundTag;
        readCollection<T, C extends Internal.Collection<T>>($$0: Internal.IntFunction_<C>, $$1: Internal.FriendlyByteBuf$Reader_<T>): C;
        writeIntIdList($$0: Internal.IntList_): void;
        readUtf($$0: number): string;
        readNbt(): Internal.CompoundTag;
        readWithCount($$0: Internal.Consumer_<Internal.FriendlyByteBuf>): void;
        readById<T>($$0: Internal.IdMap_<Internal.Holder<T>>, $$1: Internal.FriendlyByteBuf$Reader_<T>): Internal.Holder<T>;
        writeMap<K, V>($$0: Internal.Map_<K, V>, $$1: Internal.FriendlyByteBuf$Writer_<K>, $$2: Internal.FriendlyByteBuf$Writer_<V>): void;
        readComponent(): net.minecraft.network.chat.Component;
        readVarIntArray(): number[];
        readUtf(): string;
        readMap<K, V, M extends Internal.Map<K, V>>($$0: Internal.IntFunction_<M>, $$1: Internal.FriendlyByteBuf$Reader_<K>, $$2: Internal.FriendlyByteBuf$Reader_<V>): M;
        writeResourceKey($$0: Internal.ResourceKey_<any>): void;
        readOptional<T>($$0: Internal.FriendlyByteBuf$Reader_<T>): Internal.Optional<T>;
        writePublicKey($$0: Internal.PublicKey_): this;
        readIntIdList(): Internal.IntList;
        writeId<T>($$0: Internal.IdMap_<T>, $$1: T): void;
        readVector3f(): Vec3f;
        readProperty(): com.mojang.authlib.properties.Property;
        writeBlockPos($$0: BlockPos_): this;
        readBitSet(): Internal.BitSet;
        writeSectionPos($$0: Internal.SectionPos_): this;
        writeBlockHitResult($$0: Internal.BlockHitResult_): void;
        readById<T>($$0: Internal.IdMap_<T>): T;
        accessByteBufWithCorrectSize(): number[];
        readList<T>($$0: Internal.FriendlyByteBuf$Reader_<T>): Internal.List<T>;
        readByteArray($$0: number): number[];
        readSectionPos(): Internal.SectionPos;
        readEnumSet<E extends Internal.Enum<E>>($$0: E): Internal.EnumSet<E>;
        /**
         * @deprecated
        */
        readWithCodec<T>($$0: Internal.DynamicOps_<Internal.Tag>, $$1: Internal.Codec_<T>): T;
        readUUID(): Internal.UUID;
        readGameProfile(): Internal.GameProfile;
        readFixedBitSet($$0: number): Internal.BitSet;
        writeBitSet($$0: Internal.BitSet_): void;
        static getVarIntSize($$0: number): number;
        writeQuaternion($$0: Quaternionf_): void;
        static limitValue<T>($$0: Internal.IntFunction_<T>, $$1: number): Internal.IntFunction<T>;
        readItem(): Internal.ItemStack;
        writeGlobalPos($$0: Internal.GlobalPos_): void;
        touch(): Internal.ReferenceCounted;
        writeComponent($$0: net.minecraft.network.chat.Component_): this;
        writeGameProfile($$0: Internal.GameProfile_): void;
        writeVarInt($$0: number): this;
        writeEnumSet<E extends Internal.Enum<E>>($$0: Internal.EnumSet_<E>, $$1: E): void;
        writeGameProfileProperties($$0: Internal.PropertyMap_): void;
        readNullable<T>($$0: Internal.FriendlyByteBuf$Reader_<T>): T;
        writeEnum($$0: Internal.Enum_<any>): this;
        readGameProfileProperties(): Internal.PropertyMap;
        writeVarIntArray($$0: number[]): this;
        static readonly MAX_COMPONENT_STRING_LENGTH: 262144;
        static readonly DEFAULT_NBT_QUOTA: 2097152;
        static readonly MAX_STRING_LENGTH: 32767;
    }
    type FriendlyByteBuf_ = FriendlyByteBuf;
    class CoralBlock extends Internal.Block {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CoralBlock_ = CoralBlock;
    class CropBlock extends Internal.BushBlock implements com.simibubi.create.foundation.mixin.accessor.CropBlockAccessor, Internal.CropBlockAccessor, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        handler$bdi000$balm$randomTickPreGrow(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, callbackInfo: Internal.CallbackInfo_): void;
        setRequiresTool(v: boolean): void;
        invokeMethod_9824(): Internal.IntegerProperty;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        getStateForAge($$0: number): Internal.BlockState;
        setLightEmission(v: number): void;
        isMaxAge($$0: Internal.BlockState_): boolean;
        getMod(): string;
        handler$bdg000$balm$mayPlaceOn(state: Internal.BlockState_, blockGetter: Internal.BlockGetter_, pos: BlockPos_, callbackInfo: Internal.CallbackInfoReturnable_<any>): void;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        growCrops($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getAge($$0: Internal.BlockState_): number;
        handler$bdi000$balm$randomTickPostGrow(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, callbackInfo: Internal.CallbackInfo_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        create$callGetAgeProperty(): Internal.IntegerProperty;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getMaxAge(): number;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get maxAge(): number
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 7;
    }
    type CropBlock_ = CropBlock;
    class Rabbit extends Internal.Animal implements Internal.VariantHolder<Internal.Rabbit$Variant> {
        constructor($$0: Internal.EntityType_<Internal.Rabbit>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getJumpCompletion($$0: number): number;
        isTouchingUpsideDownFluid(): boolean;
        handler$cnf000$farmersdelight$isCabbage(stack: Internal.ItemStack_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getVariant(): any;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getVariant(): Internal.Rabbit$Variant;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        startJumping(): void;
        method_5958(): void;
        setVariant($$0: Internal.Rabbit$Variant_): void;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setSpeedModifier($$0: number): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        static checkRabbitSpawnRules($$0: Internal.EntityType_<Internal.Rabbit>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get variant(): Internal.Rabbit$Variant
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set variant($$0: Internal.Rabbit$Variant_)
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set speedModifier($$0: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
        static readonly STROLL_SPEED_MOD: 0.6;
        static readonly EVIL_ATTACK_POWER: 8;
        static readonly EVIL_ARMOR_VALUE: 8;
        static readonly BREED_SPEED_MOD: 0.8;
        static readonly FLEE_SPEED_MOD: 2.2;
        static readonly FOLLOW_SPEED_MOD: 1.0;
        static readonly ATTACK_SPEED_MOD: 1.4;
    }
    type Rabbit_ = Rabbit;
    abstract class Charset implements Internal.Comparable<Internal.Charset> {
        static isSupported(arg0: string): boolean;
        aliases(): Internal.Set<string>;
        static availableCharsets(): Internal.SortedMap<string, Internal.Charset>;
        displayName(): string;
        abstract newEncoder(): Internal.CharsetEncoder;
        abstract newDecoder(): Internal.CharsetDecoder;
        static forName(arg0: string, arg1: Internal.Charset_): Internal.Charset;
        encode(arg0: string): Internal.ByteBuffer;
        canEncode(): boolean;
        isRegistered(): boolean;
        compareTo(arg0: any): number;
        decode(arg0: Internal.ByteBuffer_): Internal.CharBuffer;
        name(): string;
        abstract contains(arg0: Internal.Charset_): boolean;
        displayName(arg0: Internal.Locale_): string;
        compareTo(arg0: Internal.Charset_): number;
        static defaultCharset(): Internal.Charset;
        encode(arg0: Internal.CharBuffer_): Internal.ByteBuffer;
        static forName(arg0: string): Internal.Charset;
        get registered(): boolean
    }
    type Charset_ = Charset;
    class CustomLecternBlock extends Internal.LecternBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static defaultUseItemOn(context: Internal.UseOnContext_): Internal.InteractionResult;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.CustomLecternBlockEntity;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static replaceLectern(level: Internal.Level_, pos: BlockPos_, blockState: Internal.BlockState_, item: Internal.ItemStack_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CustomLecternBlock_ = CustomLecternBlock;
    class Camel extends Internal.AbstractHorse implements Internal.Saddleable, Internal.PlayerRideableJumping, Internal.RiderShieldingMount {
        constructor($$0: Internal.EntityType_<Internal.Camel>, $$1: Internal.Level_)
        resetLastPoseChangeTick($$0: number): void;
        getPoseTime(): number;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        isCamelVisuallySitting(): boolean;
        standUpInstantly(): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        isInPoseTransition(): boolean;
        canRiderInteract(): boolean;
        isPanicking(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getRiderShieldingHeight(): number;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        setDashing($$0: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        standUp(): void;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isDashing(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        sitDown(): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        isCamelSitting(): boolean;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        refuseToMove(): boolean;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get poseTime(): number
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get camelVisuallySitting(): boolean
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get inPoseTransition(): boolean
        get panicking(): boolean
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get riderShieldingHeight(): number
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        set dashing($$0: boolean)
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get dashing(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get camelSitting(): boolean
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly DASH_COOLDOWN_TICKS: 55;
        readonly sitUpAnimationState: Internal.AnimationState;
        readonly idleAnimationState: Internal.AnimationState;
        readonly dashAnimationState: Internal.AnimationState;
        static readonly LAST_POSE_CHANGE_TICK: Internal.EntityDataAccessor<number>;
        readonly sitPoseAnimationState: Internal.AnimationState;
        static readonly MAX_HEAD_Y_ROT: 30;
        static readonly TEMPTATION_ITEM: Internal.Ingredient;
        readonly sitAnimationState: Internal.AnimationState;
        static readonly DASH: Internal.EntityDataAccessor<boolean>;
    }
    type Camel_ = Camel;
    class Carriage$DimensionalCarriageEntity {
        constructor(this$0: Internal.Carriage_)
        findPivot(dimension: Internal.ResourceKey_<Internal.Level>, leading: boolean): Internal.TrackNodeLocation;
        updateCutoff(leadingIsCurrent: boolean): void;
        trailingAnchor(): Vec3d;
        updatePassengerLoadout(): void;
        write(): Internal.CompoundTag;
        read(tag: Internal.CompoundTag_): void;
        maxAllowedLocalCoord(): number;
        updateRenderedCutoff(): void;
        minAllowedLocalCoord(): number;
        leadingAnchor(): Vec3d;
        alignEntity(entity: Internal.CarriageContraptionEntity_): void;
        discardPivot(): void;
        pivot: Internal.TrackNodeLocation;
        rotationAnchors: Internal.Couple<Vec3d>;
        pointsInitialised: boolean;
        cutoff: number;
        positionAnchor: Vec3d;
        entity: Internal.WeakReference<Internal.CarriageContraptionEntity>;
    }
    type Carriage$DimensionalCarriageEntity_ = Carriage$DimensionalCarriageEntity;
    class TrackBufferBlockEntity extends Internal.DyeableBlockEntity implements Internal.TransformableBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(blockEntity: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        edgePoint: Internal.TrackTargetingBehaviour<Internal.TrackBuffer>;
    }
    type TrackBufferBlockEntity_ = TrackBufferBlockEntity;
    interface BlockEntityPredicateDataCheck {
        abstract checkData(arg0: Internal.CompoundTag_): boolean;
        (arg0: Internal.CompoundTag): boolean;
    }
    type BlockEntityPredicateDataCheck_ = BlockEntityPredicateDataCheck;
    interface SophisticatedEntity {
        sophisticatedCaptureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        sophisticatedCaptureDrops(): Internal.Collection<Internal.ItemEntity>;
        sophisticatedInvalidateCaps(): void;
        getSophisticatedCustomData(): Internal.CompoundTag;
        get sophisticatedCustomData(): Internal.CompoundTag
    }
    type SophisticatedEntity_ = SophisticatedEntity;
    abstract class AbstractCastingBlock extends Internal.TableBlock {
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        isRequireCast(): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get requireCast(): boolean
        set destroySpeed(v: number)
    }
    type AbstractCastingBlock_ = AbstractCastingBlock;
    class CustomMapData$Type <T extends Internal.CustomMapData<any>> extends Internal.Record {
        constructor(id: ResourceLocation_, factory: Internal.Supplier_<T>)
        id(): ResourceLocation;
        get(mapData: Internal.MapItemSavedData_): T;
        factory(): Internal.Supplier<T>;
    }
    type CustomMapData$Type_<T extends Internal.CustomMapData<any>> = CustomMapData$Type<T>;
    abstract class ArtifactItem extends Internal.Item {
        constructor()
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        addCooldown(entity: Internal.LivingEntity_, ticks: number): void;
        abstract isCosmetic(): boolean;
        isOnCooldown(entity: Internal.LivingEntity_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get cosmetic(): boolean
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ArtifactItem_ = ArtifactItem;
    interface FluidExtension {
        getFluidType(): Internal.FluidType;
        get fluidType(): Internal.FluidType
    }
    type FluidExtension_ = FluidExtension;
    class ItemStackSet implements Internal.Iterable<Internal.ItemStack> {
        constructor(...items: Internal.ItemStack_[])
        constructor()
        constructor(initialSize: number)
        add(stack: Internal.ItemStack_): void;
        size(): number;
        forEach(action: Internal.Consumer_<Internal.ItemStack>): void;
        contains(stack: Internal.ItemStack_): boolean;
        toList(): Internal.List<Internal.ItemStack>;
        addItem(item: Internal.Item_): void;
        toArray(): Internal.ItemStack[];
        remove(stack: Internal.ItemStack_): void;
        getFirst(): Internal.ItemStack;
        isEmpty(): boolean;
        iterator(): Internal.Iterator<Internal.ItemStack>;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        get first(): Internal.ItemStack
        get empty(): boolean
    }
    type ItemStackSet_ = ItemStackSet;
    abstract class SimpleFlowableFluid extends Internal.FlowingFluid {
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type SimpleFlowableFluid_ = SimpleFlowableFluid;
    abstract class ForwardingList <E> extends Internal.ForwardingCollection<E> implements Internal.List<E> {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        addLast(arg0: E): void;
        get(arg0: number): E;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getLast(): E;
        listIterator(): Internal.ListIterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        sort(arg0: Internal.Comparator_<E>): void;
        set(arg0: number, arg1: E): E;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        remove(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        subList(arg0: number, arg1: number): Internal.List<E>;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        indexOf(arg0: any): number;
        addFirst(arg0: E): void;
        add(arg0: number, arg1: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<E>;
        getFirst(): E;
        abstract iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        lastIndexOf(arg0: any): number;
        get last(): E
        get first(): E
    }
    type ForwardingList_<E> = ForwardingList<E>;
    interface ShortPredicate extends Internal.Predicate<number>, Internal.IntPredicate {
        /**
         * @deprecated
        */
        and(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        abstract test(arg0: number): boolean;
        and(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        or(arg0: Internal.ShortPredicate_): this;
        or(arg0: Internal.IntPredicate_): this;
        /**
         * @deprecated
        */
        or(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        negate(): Internal.IntPredicate;
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        and(arg0: Internal.ShortPredicate_): this;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        /**
         * @deprecated
        */
        test(arg0: any): boolean;
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        (arg0: number): boolean;
    }
    type ShortPredicate_ = ShortPredicate;
    class ExpirableValue <T> {
        constructor($$0: T, $$1: number)
        static codec<T>($$0: Internal.Codec_<T>): Internal.Codec<Internal.ExpirableValue<T>>;
        canExpire(): boolean;
        static of<T>($$0: T): Internal.ExpirableValue<T>;
        static of<T>($$0: T, $$1: number): Internal.ExpirableValue<T>;
        getValue(): T;
        hasExpired(): boolean;
        tick(): void;
        getTimeToLive(): number;
        get value(): T
        get timeToLive(): number
    }
    type ExpirableValue_<T> = ExpirableValue<T>;
    interface GameEventListener$Holder <T extends Internal.GameEventListener> {
        abstract getListener(): T;
        get listener(): T
        (): T;
    }
    type GameEventListener$Holder_<T extends Internal.GameEventListener> = GameEventListener$Holder<T>;
    interface DataObject {
        abstract save(): Internal.CompoundTag;
        abstract load(arg0: Internal.CompoundTag_): void;
    }
    type DataObject_ = DataObject;
    class ItemStackUtil$StackWrapper {
        constructor(stack: Internal.ItemStack_)
        readonly stack: Internal.ItemStack;
        static readonly EMPTY_WRAPPER: Internal.ItemStackUtil$StackWrapper;
    }
    type ItemStackUtil$StackWrapper_ = ItemStackUtil$StackWrapper;
    /**
     * Invoked when a block is destroyed by a player.
    */
    class BlockBrokenEventJS extends Internal.PlayerEventJS {
        constructor(entity: Internal.ServerPlayer_, level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, xp: any_)
        /**
         * The experience dropped by the block. Always `0` on Fabric.
        */
        getXp(): number;
        /**
         * The player that broke the block.
        */
        getEntity(): Internal.Entity;
        /**
         * Sets the experience dropped by the block. Only works on Forge.
        */
        setXp(xp: number): void;
        /**
         * The block that was broken.
        */
        getBlock(): Internal.BlockContainerJS;
        /**
         * The experience dropped by the block. Always `0` on Fabric.
        */
        get xp(): number
        /**
         * The player that broke the block.
        */
        get entity(): Internal.Entity
        /**
         * Sets the experience dropped by the block. Only works on Forge.
        */
        set xp(xp: number)
        /**
         * The block that was broken.
        */
        get block(): Internal.BlockContainerJS
    }
    type BlockBrokenEventJS_ = BlockBrokenEventJS;
    class DieselSmokeStackBlock extends Internal.AbstractSmokeStackBlock<Internal.DieselSmokeStackBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_, shape: any_)
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.DieselSmokeStackBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.DieselSmokeStackBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.DieselSmokeStackBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.DieselSmokeStackBlockEntity;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.DieselSmokeStackBlockEntity>): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityClass(): typeof Internal.DieselSmokeStackBlockEntity;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.DieselSmokeStackBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.DieselSmokeStackBlockEntity
        static readonly FACING: Internal.DirectionProperty;
    }
    type DieselSmokeStackBlock_ = DieselSmokeStackBlock;
    abstract class Stages {
        constructor(p: Internal.Player_)
        static overrideCreation(event: Internal.Consumer_<Internal.StageCreationEvent>): void;
        static create(player: Internal.Player_): Internal.Stages;
        replace(stages: Internal.Collection_<string>): void;
        static removed(event: Internal.Consumer_<Internal.StageChangeEvent>): void;
        abstract getAll(): Internal.Collection<string>;
        static added(event: Internal.Consumer_<Internal.StageChangeEvent>): void;
        add(stage: string): boolean;
        abstract addNoUpdate(arg0: string): boolean;
        static invokeAdded(stages: Internal.Stages_, stage: string): void;
        abstract removeNoUpdate(arg0: string): boolean;
        has(stage: string): boolean;
        static get(player: Internal.Player_): Internal.Stages;
        static invokeRemoved(stages: Internal.Stages_, stage: string): void;
        set(stage: string, enabled: boolean): boolean;
        toggle(stage: string): boolean;
        remove(stage: string): boolean;
        sync(): void;
        clear(): boolean;
        get all(): Internal.Collection<string>
        readonly player: Internal.Player;
    }
    type Stages_ = Stages;
    class ConjureParticleOptions extends Internal.Record implements Internal.ParticleOptions {
        constructor(color: number)
        color(): number;
        getType(): Internal.ParticleType<any>;
        writeToString(): string;
        writeToNetwork(buf: Internal.FriendlyByteBuf_): void;
        get type(): Internal.ParticleType<any>
        static readonly DESERIALIZER: Internal.ParticleOptions$Deserializer<Internal.ConjureParticleOptions>;
    }
    type ConjureParticleOptions_ = ConjureParticleOptions;
    class SynchedEntityData$DataItem <T> {
        constructor($$0: Internal.EntityDataAccessor_<T>, $$1: T)
        setValue($$0: T): void;
        value(): Internal.SynchedEntityData$DataValue<T>;
        isSetToDefault(): boolean;
        getValue(): T;
        isDirty(): boolean;
        setDirty($$0: boolean): void;
        getAccessor(): Internal.EntityDataAccessor<T>;
        set value($$0: T)
        get setToDefault(): boolean
        get value(): T
        get dirty(): boolean
        set dirty($$0: boolean)
        get accessor(): Internal.EntityDataAccessor<T>
    }
    type SynchedEntityData$DataItem_<T> = SynchedEntityData$DataItem<T>;
    class GlassBlock extends Internal.AbstractGlassBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type GlassBlock_ = GlassBlock;
    class WildflowerBlock extends Internal.PinkPetalsBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type WildflowerBlock_ = WildflowerBlock;
    interface IMeltingContainer extends Internal.ISingleStackContainer {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem(itemIn: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf(set: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        abstract getStack(): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        abstract getOreRate(): Internal.IMeltingContainer$IOreRate;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get stack(): Internal.ItemStack
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get height(): number
        get oreRate(): Internal.IMeltingContainer$IOreRate
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type IMeltingContainer_ = IMeltingContainer;
    interface AccessorStructureTemplatePool {
        abstract bookshelf$setRawTemplates(arg0: Internal.List_<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>): void;
        abstract bookshelf$setTemplates(arg0: Internal.ObjectArrayList_<Internal.StructurePoolElement>): void;
        abstract bookshelf$getTemplates(): Internal.ObjectArrayList<Internal.StructurePoolElement>;
        abstract bookshelf$getRawTemplates(): Internal.List<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>;
    }
    type AccessorStructureTemplatePool_ = AccessorStructureTemplatePool;
    class EntityLookup <T extends Internal.EntityAccess> {
        constructor()
        getEntity($$0: Internal.UUID_): T;
        getAllEntities(): Internal.Iterable<T>;
        count(): number;
        remove($$0: T): void;
        getEntities<U extends T>($$0: Internal.EntityTypeTest_<T, U>, $$1: Internal.AbortableIterationConsumer_<U>): void;
        add($$0: T): void;
        getEntity($$0: number): T;
        get allEntities(): Internal.Iterable<T>
    }
    type EntityLookup_<T extends Internal.EntityAccess> = EntityLookup<T>;
    class Pillager extends Internal.AbstractIllager implements Internal.InventoryCarrier, Internal.CrossbowAttackMob {
        constructor($$0: Internal.EntityType_<Internal.Pillager>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getInventory(): Internal.SimpleContainer;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setChargingCrossbow($$0: boolean): void;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        isChargingCrossbow(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getProjectileShotVector($$0: Internal.LivingEntity_, $$1: Vec3d_, $$2: number): Vec3f;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        static pickUpItem($$0: Internal.Mob_, $$1: Internal.InventoryCarrier_, $$2: Internal.ItemEntity_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        readInventoryFromTag($$0: Internal.CompoundTag_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        writeInventoryToTag($$0: Internal.CompoundTag_): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        shootCrossbowProjectile($$0: Internal.LivingEntity_, $$1: Internal.ItemStack_, $$2: Internal.Projectile_, $$3: number): void;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        shootCrossbowProjectile($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_, $$2: Internal.Projectile_, $$3: number, $$4: number): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        performCrossbowAttack($$0: Internal.LivingEntity_, $$1: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        performRangedAttack($$0: Internal.LivingEntity_, $$1: number): void;
        onCrossbowAttackPerformed(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get inventory(): Internal.SimpleContainer
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set chargingCrossbow($$0: boolean)
        set y(y: number)
        get living(): boolean
        get chargingCrossbow(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Pillager_ = Pillager;
    interface MemoryTrackingRenderBuffers {
        abstract getMiscBufferAllocatedSize(): number;
        abstract freeAndDeleteBuffers(): void;
        abstract getEntityBufferAllocatedSize(): number;
        abstract getMaxBegins(): number;
        get miscBufferAllocatedSize(): number
        get entityBufferAllocatedSize(): number
        get maxBegins(): number
    }
    type MemoryTrackingRenderBuffers_ = MemoryTrackingRenderBuffers;
    class TinyMap <K, V> extends Internal.Record {
        constructor(map: Internal.TinyMap_<K, V>)
        constructor(entries: any_<K, V>[])
        constructor(collection: Internal.Collection_<any>)
        entries(): any[];
        isEmpty(): boolean;
        static ofMap<K, V>(map: Internal.Map_<K, V>): Internal.TinyMap<K, V>;
        get empty(): boolean
    }
    type TinyMap_<K, V> = TinyMap<K, V>;
    class BlockJar extends Internal.BaseEntityBlock {
        constructor(pixieType: number)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        isEmpty(): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static name(pixieType: number): string;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getPixieType(): number;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, entityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        dropPixie(world: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get empty(): boolean
        get blockStates(): Internal.List<Internal.BlockState>
        get pixieType(): number
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockJar_ = BlockJar;
    class Of2 <A, B> {
    }
    type Of2_<A, B> = [A, B] | [B, A];
    class SpriteContents$FrameInfo implements Internal.SpriteContentsFrameInfoAccessor, Internal.SpriteContentsAnimationFrameAccessor, me.jellysquid.mods.sodium.mixin.features.textures.animations.tracking.SpriteContentsAnimationFrameAccessor {
        getTime(): number;
        getIndex(): number;
        getField_28475(): number;
        getField_28476(): number;
        get time(): number
        get index(): number
        get field_28475(): number
        get field_28476(): number
        readonly index: number;
        readonly time: number;
    }
    type SpriteContents$FrameInfo_ = SpriteContents$FrameInfo;
    interface FluidVariantAttributeHandler {
        getLuminance(variant: Internal.FluidVariant_): number;
        getFillSound(variant: Internal.FluidVariant_): Internal.Optional<Internal.SoundEvent>;
        isLighterThanAir(variant: Internal.FluidVariant_): boolean;
        getName(fluidVariant: Internal.FluidVariant_): net.minecraft.network.chat.Component;
        getEmptySound(variant: Internal.FluidVariant_): Internal.Optional<Internal.SoundEvent>;
        getViscosity(variant: Internal.FluidVariant_, world: Internal.Level_): number;
        getTemperature(variant: Internal.FluidVariant_): number;
    }
    type FluidVariantAttributeHandler_ = FluidVariantAttributeHandler;
    interface OutputReplacement {
        replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
        transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
        of(o: any): this;
    }
    type OutputReplacement_ = OutputItem_ | OutputReplacement;
    class FlowerBlock extends Internal.BushBlock implements Internal.SuspiciousEffectHolder {
        constructor($$0: Internal.MobEffect_, $$1: number, $$2: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getSuspiciousEffect(): Internal.MobEffect;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static tryGet($$0: Internal.ItemLike_): Internal.SuspiciousEffectHolder;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getEffectDuration(): number;
        static getAllEffectHolders(): Internal.List<Internal.SuspiciousEffectHolder>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get suspiciousEffect(): Internal.MobEffect
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get effectDuration(): number
        get allEffectHolders(): Internal.List<Internal.SuspiciousEffectHolder>
    }
    type FlowerBlock_ = FlowerBlock;
    class RegistryAttribute extends Internal.Enum<Internal.RegistryAttribute> {
        static valueOf(name: string): Internal.RegistryAttribute;
        static values(): Internal.RegistryAttribute[];
        static readonly MODDED: Internal.RegistryAttribute;
        static readonly SYNCED: Internal.RegistryAttribute;
        static readonly PERSISTED: Internal.RegistryAttribute;
    }
    type RegistryAttribute_ = "modded" | RegistryAttribute | "persisted" | "synced";
    abstract class SimpleJsonResourceReloadListener extends Internal.SimplePreparableReloadListener<Internal.Map<ResourceLocation, Internal.JsonElement>> {
        constructor($$0: Internal.Gson_, $$1: string)
        static scanDirectory($$0: Internal.ResourceManager_, $$1: string, $$2: Internal.Gson_, $$3: Internal.Map_<ResourceLocation, Internal.JsonElement>): void;
        getName(): string;
        get name(): string
    }
    type SimpleJsonResourceReloadListener_ = SimpleJsonResourceReloadListener;
    class SolarBlock extends Internal.AbstractGeneratorBlock<Internal.SolarBlock> implements Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockItem(arg0: Internal.Item$Properties_, arg1: Internal.ResourceKey_<any>): Internal.ItemBlock<any, any>;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getConfig(): Internal.GeneratorConfig;
        canAttach(state: Internal.BlockState_, world: Internal.LevelAccessor_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        getConnectedSides(state: Internal.BlockState_): Internal.List<Internal.Direction>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get config(): Internal.GeneratorConfig
        static readonly NORTH: Internal.BooleanProperty;
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type SolarBlock_ = SolarBlock;
    class EdgePointType <T extends Internal.TrackEdgePoint> {
        constructor(id: ResourceLocation_, factory: Internal.Supplier_<T>)
        getId(): ResourceLocation;
        static register<T extends Internal.TrackEdgePoint>(id: ResourceLocation_, factory: Internal.Supplier_<T>): Internal.EdgePointType<T>;
        create(): T;
        static read(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): Internal.TrackEdgePoint;
        get id(): ResourceLocation
        static readonly OBSERVER: Internal.EdgePointType<Internal.TrackObserver>;
        static readonly TYPES: {[key: ResourceLocation]: Internal.EdgePointType<any>, [key: ResourceLocation]: Internal.EdgePointType<any>, [key: ResourceLocation]: Internal.EdgePointType<any>, [key: ResourceLocation]: Internal.EdgePointType<any>, [key: ResourceLocation]: Internal.EdgePointType<any>, [key: ResourceLocation]: Internal.EdgePointType<any>};
        static readonly STATION: Internal.EdgePointType<Internal.GlobalStation>;
        static readonly SIGNAL: Internal.EdgePointType<Internal.SignalBoundary>;
    }
    type EdgePointType_<T extends Internal.TrackEdgePoint> = EdgePointType<T>;
    class OreMeltingRecipe$Serializer extends Internal.MeltingRecipe$AbstractSerializer<any> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.MeltingRecipe;
    }
    type OreMeltingRecipe$Serializer_ = OreMeltingRecipe$Serializer;
    class TripleAxleBogeyBlock extends Internal.CRBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TripleAxleBogeyBlock_ = TripleAxleBogeyBlock;
    class Layer$Instance$AnchorSide extends Internal.Enum<Internal.Layer$Instance$AnchorSide> {
        static values(): Internal.Layer$Instance$AnchorSide[];
        static valueOf(name: string): Internal.Layer$Instance$AnchorSide;
        static readonly TOP: Internal.Layer$Instance$AnchorSide;
        static readonly BOTTOM: Internal.Layer$Instance$AnchorSide;
        static readonly RIGHT: Internal.Layer$Instance$AnchorSide;
        static readonly LEFT: Internal.Layer$Instance$AnchorSide;
    }
    type Layer$Instance$AnchorSide_ = Layer$Instance$AnchorSide | "bottom" | "top" | "right" | "left";
    class ComfortEffect extends Internal.MobEffect {
        constructor()
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
        getRenderer(): Internal.MobEffectRenderer;
        get curativeItems(): Internal.List<Internal.ItemStack>
        get renderer(): Internal.MobEffectRenderer
    }
    type ComfortEffect_ = ComfortEffect;
    class BlockConjuredLight extends Internal.BlockConjured implements Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        hasEnchantPowerBonus(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type BlockConjuredLight_ = BlockConjuredLight;
    abstract class ActorVisual implements Internal.Visual {
        constructor(visualizationContext: Internal.VisualizationContext_, world: Internal.BlockAndTintGetter_, context: Internal.MovementContext_)
        update(partialTick: number): void;
        beginFrame(): void;
        tick(): void;
        "delete"(): void;
    }
    type ActorVisual_ = ActorVisual;
    interface ConnectableRedstoneBlock {
        canConnectRedstone(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): boolean;
    }
    type ConnectableRedstoneBlock_ = ConnectableRedstoneBlock;
    interface Function1 <P1, R> extends kotlin.Function<R> {
        abstract invoke(arg0: P1): R;
        (arg0: P1): R;
    }
    type Function1_<P1, R> = Function1<P1, R>;
    class ItemPridePigment extends Internal.Item implements Internal.PigmentItem {
        constructor(type: Internal.ItemPridePigment$Type_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        provideColor(stack: Internal.ItemStack_, owner: Internal.UUID_): Internal.ColorProvider;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        readonly type: Internal.ItemPridePigment$Type;
    }
    type ItemPridePigment_ = ItemPridePigment;
    class WardenEntitySensor extends Internal.NearestLivingEntitySensor<Internal.Warden> {
        constructor()
    }
    type WardenEntitySensor_ = WardenEntitySensor;
    class MemoryStatus extends Internal.Enum<Internal.MemoryStatus> {
        static valueOf($$0: string): Internal.MemoryStatus;
        static values(): Internal.MemoryStatus[];
        static readonly VALUE_PRESENT: Internal.MemoryStatus;
        static readonly VALUE_ABSENT: Internal.MemoryStatus;
        static readonly REGISTERED: Internal.MemoryStatus;
    }
    type MemoryStatus_ = "value_present" | MemoryStatus | "value_absent" | "registered";
    abstract class BlockBaseGui <T extends Internal.AEBaseBlockEntity> extends Internal.AEBaseEntityBlock<T> {
        constructor()
        constructor(props: Internal.BlockBehaviour$Properties_)
        abstract openGui(arg0: T, arg1: Internal.Player_): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        check(tile: T, stack: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, hit: Internal.BlockHitResult_, p: Internal.Player_): Internal.InteractionResult;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockBaseGui_<T extends Internal.AEBaseBlockEntity> = BlockBaseGui<T>;
    class TeslaCoilBlockEntity extends Internal.BaseElectricBlockEntity implements Internal.IHaveGoggleInformation {
        constructor(tileEntityTypeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        find(item: Internal.ItemStack_, wrapper: Internal.RecipeWrapper_, level: Internal.Level_): Internal.Optional<Internal.ChargingRecipe>;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        isPoweredState(): boolean;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getConsumption(): number;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        tickAudio(): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get poweredState(): boolean
        get consumption(): number
        get infiniteBoundingBox(): Internal.AABB
        processingBehaviour: Internal.BeltProcessingBehaviour;
    }
    type TeslaCoilBlockEntity_ = TeslaCoilBlockEntity;
    class ServerboundSetCreativeModeSlotPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: Internal.ItemStack_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getItem(): Internal.ItemStack;
        getSlotNum(): number;
        isSkippable(): boolean;
        get item(): Internal.ItemStack
        get slotNum(): number
        get skippable(): boolean
    }
    type ServerboundSetCreativeModeSlotPacket_ = ServerboundSetCreativeModeSlotPacket;
    class FluidState extends Internal.StateHolder<Internal.Fluid, Internal.FluidState> implements Internal.FluidStateExtension {
        constructor($$0: Internal.Fluid_, $$1: Internal.ImmutableMap_<Internal.Property<any>, Internal.Comparable<any>>, $$2: Internal.MapCodec_<Internal.FluidState>)
        tick($$0: Internal.Level_, $$1: BlockPos_): void;
        isSource(): boolean;
        getType(): Internal.Fluid;
        is($$0: Internal.HolderSet_<Internal.Fluid>): boolean;
        getDripParticle(): Internal.ParticleOptions;
        getShape($$0: Internal.BlockGetter_, $$1: BlockPos_): Internal.VoxelShape;
        shouldRenderBackwardUpFace($$0: Internal.BlockGetter_, $$1: BlockPos_): boolean;
        is($$0: Internal.Fluid_): boolean;
        getExplosionResistance(): number;
        getHeight($$0: Internal.BlockGetter_, $$1: BlockPos_): number;
        isEmpty(): boolean;
        canBeReplacedWith($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.Fluid_, $$3: Internal.Direction_): boolean;
        createLegacyBlock(): Internal.BlockState;
        getFlow($$0: Internal.BlockGetter_, $$1: BlockPos_): Vec3d;
        holder(): Internal.Holder<Internal.Fluid>;
        getTags(): Internal.Stream<Internal.TagKey<Internal.Fluid>>;
        isSourceOfType($$0: Internal.Fluid_): boolean;
        getAmount(): number;
        getFluidType(): Internal.FluidType;
        isRandomlyTicking(): boolean;
        is($$0: Internal.TagKey_<Internal.Fluid>): boolean;
        getOwnHeight(): number;
        randomTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.RandomSource_): void;
        animateTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.RandomSource_): void;
        get source(): boolean
        get type(): Internal.Fluid
        get dripParticle(): Internal.ParticleOptions
        get explosionResistance(): number
        get empty(): boolean
        get tags(): Internal.Stream<Internal.TagKey<Internal.Fluid>>
        get amount(): number
        get fluidType(): Internal.FluidType
        get randomlyTicking(): boolean
        get ownHeight(): number
        static readonly AMOUNT_FULL: 8;
        static readonly AMOUNT_MAX: 9;
        static readonly CODEC: Internal.Codec<Internal.FluidState>;
    }
    type FluidState_ = FluidState;
    class ChunkAccess$TicksToSave extends Internal.Record {
        constructor($$0: Internal.SerializableTickContainer_<Internal.Block>, $$1: Internal.SerializableTickContainer_<Internal.Fluid>)
        fluids(): Internal.SerializableTickContainer<Internal.Fluid>;
        blocks(): Internal.SerializableTickContainer<Internal.Block>;
    }
    type ChunkAccess$TicksToSave_ = ChunkAccess$TicksToSave;
    class BayouTreeConfiguration extends Internal.BOPTreeConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.BayouTreeConfiguration>;
        readonly trunkWidth: number;
    }
    type BayouTreeConfiguration_ = BayouTreeConfiguration;
    abstract class GeneratingKineticBlockEntity extends Internal.KineticBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        createNetworkId(): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        applyNewSpeed(prevSpeed: number, speed: number): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        updateGeneratedRotation(): void;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        reActivateSource: boolean;
    }
    type GeneratingKineticBlockEntity_ = GeneratingKineticBlockEntity;
    class ValueLayouts$OfDoubleImpl extends Internal.ValueLayouts$AbstractValueLayout<Internal.ValueLayouts$OfDoubleImpl> implements Internal.ValueLayout$OfDouble {
        static sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        withoutName(): Internal.ValueLayout$OfDouble;
        static sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        static of(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfDouble;
        byteOffset(...arg0: any_[]): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        static structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfDouble;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        static paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        withName(arg0: string): Internal.ValueLayout$OfDouble;
        static unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
    }
    type ValueLayouts$OfDoubleImpl_ = ValueLayouts$OfDoubleImpl;
    interface ServerPlayerEntitySyncHook {
        abstract fabric_incrementSyncId(): number;
        (): number;
    }
    type ServerPlayerEntitySyncHook_ = ServerPlayerEntitySyncHook;
    class SoundSource extends Internal.Enum<Internal.SoundSource> {
        static valueOf($$0: string): Internal.SoundSource;
        static values(): Internal.SoundSource[];
        getName(): string;
        get name(): string
        static readonly HOSTILE: Internal.SoundSource;
        static readonly MUSIC: Internal.SoundSource;
        static readonly RECORDS: Internal.SoundSource;
        static readonly NEUTRAL: Internal.SoundSource;
        static readonly MASTER: Internal.SoundSource;
        static readonly BLOCKS: Internal.SoundSource;
        static readonly PLAYERS: Internal.SoundSource;
        static readonly WEATHER: Internal.SoundSource;
        static readonly AMBIENT: Internal.SoundSource;
        static readonly VOICE: Internal.SoundSource;
    }
    type SoundSource_ = SoundSource | "records" | "weather" | "neutral" | "music" | "players" | "blocks" | "ambient" | "master" | "voice" | "hostile";
    class MeteoriteCompassItem extends Internal.AEBaseItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MeteoriteCompassItem_ = MeteoriteCompassItem;
    class Frustum implements Internal.ViewportProvider {
        constructor($$0: Internal.Frustum_)
        constructor($$0: Matrix4f_, $$1: Matrix4f_)
        prepare($$0: number, $$1: number, $$2: number): void;
        isVisible($$0: Internal.AABB_): boolean;
        offsetToFullyIncludeCameraCube($$0: number): this;
        sodium$createViewport(): Internal.Viewport;
        static readonly OFFSET_STEP: 4;
    }
    type Frustum_ = Frustum;
    class DiscoveredPath {
        constructor(distance: number, cost: number, path: Internal.List_<Internal.Couple<Internal.TrackNode>>, destination: Internal.GlobalStation_)
        destination: Internal.GlobalStation;
        path: Internal.List<Internal.Couple<Internal.TrackNode>>;
        cost: number;
        distance: number;
    }
    type DiscoveredPath_ = DiscoveredPath;
    class KeyModifiers {
        constructor(m: number)
        start(): boolean;
        numLock(): boolean;
        alt(): boolean;
        control(): boolean;
        capsLock(): boolean;
        onlyControl(): boolean;
        shift(): boolean;
        static readonly NONE: Internal.KeyModifiers;
        readonly modifiers: number;
    }
    type KeyModifiers_ = KeyModifiers;
    abstract class AgeableMob extends Internal.PathfinderMob {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        static getSpeedUpSecondsWhenFeeding($$0: number): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAge(): number;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        ageUp($$0: number, $$1: boolean): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        setAge($$0: number): void;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        abstract getBreedOffspring(arg0: Internal.ServerLevel_, arg1: Internal.AgeableMob_): this;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        canBreed(): boolean;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        ageUp($$0: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get age(): number
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        set age($$0: number)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly BABY_START_AGE: -24000;
    }
    type AgeableMob_ = AgeableMob;
    class ClientLevel extends Internal.Level implements Internal.BiomeSeedProvider, Internal.ClientLevelKJS, Internal.PhantomWorld, me.jellysquid.mods.lithium.common.client.ClientWorldAccessor, io.github.fabricators_of_create.porting_lib.transfer.internal.extensions.LevelExtensions, Internal.ExtendedWorld, Internal.ClientLevelExtensions, Internal.ChunkTrackerHolder, Internal.ClientWorldAccessor {
        constructor($$0: Internal.ClientPacketListener_, $$1: Internal.ClientLevel$ClientLevelData_, $$2: Internal.ResourceKey_<Internal.Level>, $$3: Internal.Holder_<Internal.DimensionType>, $$4: number, $$5: number, $$6: Internal.Supplier_<Internal.ProfilerFiller>, $$7: Internal.LevelRenderer_, $$8: boolean, $$9: number)
        tickNonPassenger($$0: Internal.Entity_): void;
        effects(): Internal.DimensionSpecialEffects;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        setDefaultSpawnPos($$0: BlockPos_, $$1: number): void;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        createEntityList(entities: Internal.Collection_<Internal.Entity>): Internal.EntityArrayList;
        handler$iad000$sophisticatedcore$addEntityEvent(i: number, entity: Internal.Entity_, ci: Internal.CallbackInfo_): void;
        unload($$0: Internal.LevelChunk_): void;
        tick($$0: Internal.BooleanSupplier_): void;
        getEntitiesWithin(aabb: Internal.AABB_): Internal.EntityArrayList;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        runCommandSilent(command: string): number;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        asComponentProvider(): Internal.ComponentProvider;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        getEntityCount(): number;
        updateSnapshots(ctx: Internal.TransactionContext_): void;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        setDayTime($$0: number): void;
        getEntityManager(): Internal.TransientEntitySectionManager<any>;
        port_lib$invalidateCache(pos: BlockPos_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        handler$caf000$entityculling$tickEntity(entity: Internal.Entity_, info: Internal.CallbackInfo_): void;
        handleBlockChangedAck($$0: number): void;
        clearTintCaches(): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        setGameTime($$0: number): void;
        getBlock(blockEntity: Internal.BlockEntity_): Internal.BlockContainerJS;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        calculateBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        queueLightUpdate($$0: Internal.Runnable_): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        getLevelData(): Internal.ClientLevel$ClientLevelData;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        getDirectSignalTo($$0: BlockPos_): number;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        addFreshEntity($$0: Internal.Entity_): boolean;
        putNonPlayerEntity($$0: number, $$1: Internal.Entity_): void;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getSkyFlashTime(): number;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        entitiesForRendering(): Internal.Iterable<Internal.Entity>;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getBlock(x: number, y: number, z: number): Internal.BlockContainerJS;
        handler$hle000$uranus$onEntityJoin(i: number, entity: Internal.Entity_, ci: Internal.CallbackInfo_): void;
        getSkyDarken($$0: number): number;
        animateTick($$0: number, $$1: number, $$2: number): void;
        handler$ggc000$porting_lib_entity$port_lib$addEntityEvent(i: number, entity: Internal.Entity_, ci: Internal.CallbackInfo_): void;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        setSectionDirtyWithNeighbors($$0: number, $$1: number, $$2: number): void;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        tickEntities(): void;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        port_lib$registerCache(pos: BlockPos_, cache: Internal.ClientBlockApiCache_): void;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getChunkSource(): Internal.ClientChunkCache;
        createExplosion(x: number, y: number, z: number): Internal.ExplosionJS;
        "handler$cgd000$fabric-lifecycle-events-v1$tickWorldAfterBlockEntities"(ci: Internal.CallbackInfo_): void;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        static getBiomeSeed(world: Internal.ClientLevel_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        setScoreboard($$0: Internal.Scoreboard_): void;
        isPhased(pos: BlockPos_): boolean;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getDimension(): ResourceLocation;
        getName(): net.minecraft.network.chat.Component;
        getDifficulty(): Internal.Difficulty;
        canSeeSky($$0: BlockPos_): boolean;
        getCloudColor($$0: number): Vec3d;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        unmaskPhasedBlocks(): void;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        spawnFireworks(x: number, y: number, z: number, f: Internal.FireworksJS_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        phaseBlock(pos: BlockPos_, ticks: number): void;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        static get(world: Internal.ClientLevel_): Internal.ChunkTracker;
        noCollision($$0: Internal.Entity_): boolean;
        self(): Internal.Level;
        createEntity(type: Internal.EntityType_<any>): Internal.Entity;
        getBestNeighborSignal($$0: BlockPos_): number;
        sodium$getBiomeSeed(): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        doAnimateTick($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.RandomSource_, $$5: Internal.Block_, $$6: Internal.BlockPos$MutableBlockPos_): void;
        phaseBlock(pos: BlockPos_, ticks: number, delay: number, customSrc: DamageSource_): void;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        getBlockEntityRenderData(pos: BlockPos_): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getSkyColor($$0: Vec3d_, $$1: number): Vec3d;
        getMoonBrightness(): number;
        noCollision($$0: Internal.AABB_): boolean;
        setServerSimulationDistance($$0: number): void;
        isWaterAt($$0: BlockPos_): boolean;
        isLightUpdateQueueEmpty(): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        static getAllLoadedEntities(level: Internal.Level_): Internal.Iterable<Internal.Entity>;
        getSide(): Internal.ScriptType;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        handler$zel000$porting_lib_base$port_lib$init(ci: Internal.CallbackInfo_): void;
        sodium$getTracker(): Internal.ChunkTracker;
        remaskPhasedBlocks(): void;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        removeEntity($$0: number, $$1: Internal.Entity$RemovalReason_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        getEntities(): Internal.EntityArrayList;
        spawnParticles(options: Internal.ParticleOptions_, overrideLimiter: boolean, x: number, y: number, z: number, vx: number, vy: number, vz: number, count: number, speed: number): void;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        overrideMapData($$0: string, $$1: Internal.MapItemSavedData_): void;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        setServerVerifiedBlockState($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): void;
        pollLightUpdates(): void;
        handler$dbp000$hexcasting$addBuddingAmethystParticles($$0: number, $$1: number, $$2: number, $$3: number, rand: Internal.RandomSource_, $$5: Internal.Block_, pos: Internal.BlockPos$MutableBlockPos_, ci: Internal.CallbackInfo_, trueX: number, trueY: number, trueZ: number, state: Internal.BlockState_): void;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        getServerSimulationDistance(): number;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        addPlayer($$0: number, $$1: Internal.AbstractClientPlayer_): void;
        onChunkLoaded($$0: Internal.ChunkPos_): void;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getPlayers(): Internal.EntityArrayList;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        phaseBlock(pos: BlockPos_, ticks: number, delay: number): void;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: BlockPos_): void;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        syncBlockState($$0: BlockPos_, $$1: Internal.BlockState_, $$2: Vec3d_): void;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getBlock(pos: BlockPos_): Internal.BlockContainerJS;
        isOverworld(): boolean;
        runCommand(command: string): number;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        getStarBrightness($$0: number): number;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get entityCount(): number
        set dayTime($$0: number)
        get entityManager(): Internal.TransientEntitySectionManager<any>
        set gameTime($$0: number)
        get displayName(): net.minecraft.network.chat.Component
        get levelData(): Internal.ClientLevel$ClientLevelData
        get skyFlashTime(): number
        get chunkSource(): Internal.ClientChunkCache
        set scoreboard($$0: Internal.Scoreboard_)
        get dimension(): ResourceLocation
        get name(): net.minecraft.network.chat.Component
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get moonBrightness(): number
        set serverSimulationDistance($$0: number)
        get lightUpdateQueueEmpty(): boolean
        get side(): Internal.ScriptType
        get entities(): Internal.EntityArrayList
        get serverSimulationDistance(): number
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get players(): Internal.EntityArrayList
        get maxLightLevel(): number
        get overworld(): boolean
        readonly entityStorage: Internal.TransientEntitySectionManager<Internal.Entity>;
    }
    type ClientLevel_ = ClientLevel;
    interface PiglinsNeutralItem {
        makesPiglinsNeutral(stack: Internal.ItemStack_, wearer: Internal.LivingEntity_): boolean;
    }
    type PiglinsNeutralItem_ = PiglinsNeutralItem;
    class CertusQuartzClusterBlock extends Internal.AEBaseBlock implements Internal.SimpleWaterloggedBlock {
        constructor(i: number, j: number, properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getPistonPushReaction(state: Internal.BlockState_): Internal.PushReaction;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type CertusQuartzClusterBlock_ = CertusQuartzClusterBlock;
    class DeserializationContext {
        constructor($$0: ResourceLocation_, $$1: Internal.LootDataManager_)
        deserializeConditions($$0: Internal.JsonArray_, $$1: string, $$2: Internal.LootContextParamSet_): Internal.LootItemCondition[];
        getAdvancementId(): ResourceLocation;
        get advancementId(): ResourceLocation
    }
    type DeserializationContext_ = DeserializationContext;
    class CreativeCrateBlockEntity extends Internal.CrateBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        createFilter(): Internal.FilteringBehaviour;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
    }
    type CreativeCrateBlockEntity_ = CreativeCrateBlockEntity;
    class ForbiddenSymlinkInfo extends Internal.Record {
        constructor($$0: Internal.Path_, $$1: Internal.Path_)
        target(): Internal.Path;
        link(): Internal.Path;
    }
    type ForbiddenSymlinkInfo_ = ForbiddenSymlinkInfo;
    interface MenuLocator {
        abstract locate<T>(arg0: Internal.Player_, arg1: T): T;
        (arg0: Internal.Player, arg1: T): T;
    }
    type MenuLocator_ = MenuLocator;
    interface SmithingRecipe extends Internal.Recipe<net.minecraft.world.Container> {
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        abstract isBaseIngredient(arg0: Internal.ItemStack_): boolean;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        abstract assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        abstract matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        abstract getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions($$0: number, $$1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        abstract isTemplateIngredient(arg0: Internal.ItemStack_): boolean;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        abstract isAdditionIngredient(arg0: Internal.ItemStack_): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type SmithingRecipe_ = SmithingRecipe;
    class TooltipBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, description: net.minecraft.network.chat.Component_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TooltipBlockItem_ = TooltipBlockItem;
    class MapItemSavedData$HoldingPlayer implements Internal.IHoldingPlayerExtension {
        handler$fei000$moonlight$initializeDirty(mapItemSavedData: Internal.MapItemSavedData_, player: Internal.Player_, ci: Internal.CallbackInfo_): void;
        moonlight$setCustomDataDirty(type: Internal.CustomMapData$Type_<any>, dirtySetter: Internal.Consumer_<any>): void;
        moonlight$setCustomMarkersDirty(): void;
        modifyReturnValue$fei000$moonlight$addExtraPacketData(packet: Internal.Packet_<any>, mapId: number): Internal.Packet<any>;
        handler$fei000$moonlight$sanityCheck(x: number, z: number, ci: Internal.CallbackInfo_): void;
        handler$fei000$moonlight$checkLocked(mapId: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$fei000$moonlight$lockData(x: number, z: number, ci: Internal.CallbackInfo_): void;
        readonly player: Internal.Player;
        step: number;
    }
    type MapItemSavedData$HoldingPlayer_ = MapItemSavedData$HoldingPlayer;
    class Sniffer extends Internal.Animal {
        constructor($$0: Internal.EntityType_<Internal.Animal>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getBrain(): Internal.Brain<Internal.Sniffer>;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        onDiggingComplete($$0: boolean): this;
        isTouchingUpsideDownFluid(): boolean;
        isTempted(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        transitionTo($$0: Internal.Sniffer$State_): this;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        canSniff(): boolean;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        canPlayDiggingSound(): boolean;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        isPanicking(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        isSearching(): boolean;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get brain(): Internal.Brain<Internal.Sniffer>
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get tempted(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get panicking(): boolean
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get searching(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        readonly diggingAnimationState: Internal.AnimationState;
        readonly risingAnimationState: Internal.AnimationState;
        readonly scentingAnimationState: Internal.AnimationState;
        readonly feelingHappyAnimationState: Internal.AnimationState;
        readonly sniffingAnimationState: Internal.AnimationState;
    }
    type Sniffer_ = Sniffer;
    abstract class BlockBehaviour implements Internal.AbstractBlockAccessor, Internal.BlockKJS, Internal.FeatureElement {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getOcclusionShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        getSignal($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_): number;
        /**
         * @deprecated
        */
        tick($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        neighborChanged($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Block_, $$4: BlockPos_, $$5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        getVisualShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.CollisionContext_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        randomTick($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        /**
         * @deprecated
        */
        getMenuProvider($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_): Internal.MenuProvider;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: number, $$4: number): void;
        /**
         * @deprecated
        */
        use($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Player_, $$4: Internal.InteractionHand_, $$5: Internal.BlockHitResult_): Internal.InteractionResult;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        /**
         * @deprecated
        */
        canSurvive($$0: Internal.BlockState_, $$1: Internal.LevelReader_, $$2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.CollisionContext_): Internal.VoxelShape;
        getSettings(): Internal.BlockBehaviour$Properties;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
        */
        triggerEvent($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: number, $$4: number): boolean;
        abstract asItem(): Internal.Item;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        /**
         * @deprecated
        */
        getRenderShape($$0: Internal.BlockState_): Internal.RenderShape;
        /**
         * @deprecated
        */
        skipRendering($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getLightBlock($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): number;
        /**
         * @deprecated
        */
        getDirectSignal($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_): number;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress($$0: Internal.BlockState_, $$1: Internal.Player_, $$2: Internal.BlockGetter_, $$3: BlockPos_): number;
        /**
         * @deprecated
        */
        getSeed($$0: Internal.BlockState_, $$1: BlockPos_): number;
        defaultDestroyTime(): number;
        /**
         * @deprecated
        */
        updateShape($$0: Internal.BlockState_, $$1: Internal.Direction_, $$2: Internal.BlockState_, $$3: Internal.LevelAccessor_, $$4: BlockPos_, $$5: BlockPos_): Internal.BlockState;
        getMaxVerticalOffset(): number;
        setIsRandomlyTicking(arg0: boolean): void;
        /**
         * @deprecated
        */
        rotate($$0: Internal.BlockState_, $$1: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getDrops($$0: Internal.BlockState_, $$1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion($$0: Internal.BlockState_): boolean;
        defaultMapColor(): Internal.MapColor;
        /**
         * @deprecated
        */
        entityInside($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        setNameKey(key: string): void;
        /**
         * @deprecated
        */
        canBeReplaced($$0: Internal.BlockState_, $$1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        /**
         * @deprecated
        */
        mirror($$0: Internal.BlockState_, $$1: Internal.Mirror_): Internal.BlockState;
        setRequiresTool(v: boolean): void;
        setSpeedFactor(arg0: number): void;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        getMod(): string;
        /**
         * @deprecated
        */
        canBeReplaced($$0: Internal.BlockState_, $$1: Internal.BlockPlaceContext_): boolean;
        setExplosionResistance(arg0: number): void;
        /**
         * @deprecated
        */
        isSignalSource($$0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        attack($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.CollisionContext_): Internal.VoxelShape;
        getId(): string;
        handler$gdm000$porting_lib_entity$getDestroySpeed(blockState: Internal.BlockState_, player: Internal.Player_, blockGetter: Internal.BlockGetter_, pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        onProjectileHit($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockHitResult_, $$3: Internal.Projectile_): void;
        requiredFeatures(): Internal.FeatureFlagSet;
        /**
         * @deprecated
        */
        getInteractionShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        onPlace($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: boolean): void;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        isPathfindable($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.PathComputationType_): boolean;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal($$0: Internal.BlockState_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        getFluidState($$0: Internal.BlockState_): Internal.FluidState;
        /**
         * @deprecated
        */
        onRemove($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: boolean): void;
        setHasCollision(arg0: boolean): void;
        /**
         * @deprecated
        */
        getAnalogOutputSignal($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_): number;
        /**
         * @deprecated
        */
        spawnAfterBreak($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.ItemStack_, $$4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get settings(): Internal.BlockBehaviour$Properties
        set destroySpeed(v: number)
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get maxHorizontalOffset(): number
        get maxVerticalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set blockBuilder(b: Internal.BlockBuilder_)
        set nameKey(key: string)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set speedFactor(arg0: number)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        get mod(): string
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        set soundType(arg0: SoundType_)
        set hasCollision(arg0: boolean)
        readonly properties: Internal.BlockBehaviour$Properties;
    }
    type BlockBehaviour_ = BlockBehaviour;
    interface OwnableEntity {
        abstract level(): Internal.EntityGetter;
        abstract getOwnerUUID(): Internal.UUID;
        getOwner(): Internal.LivingEntity;
        get ownerUUID(): Internal.UUID
        get owner(): Internal.LivingEntity
    }
    type OwnableEntity_ = OwnableEntity;
    class KeyZone extends Internal.Enum<Internal.KeyZone> {
        static valueOf(name: string): Internal.KeyZone;
        getName(): string;
        static values(): Internal.KeyZone[];
        tintIndex(): number;
        equals(i: number): boolean;
        get name(): string
        static readonly MID_SIDE_KEYS: Internal.KeyZone;
        static readonly ENTER_KEY: Internal.KeyZone;
        static readonly LEFT_FN_KEYS: Internal.KeyZone;
        static readonly RSHIFT: Internal.KeyZone;
        static readonly RIGHT_FN_KEYS: Internal.KeyZone;
        static readonly NUM_ROW: Internal.KeyZone;
        static readonly MID_FN_KEYS: Internal.KeyZone;
        static readonly MOST_KEYS: Internal.KeyZone;
        static readonly SPACE_KEY: Internal.KeyZone;
        static readonly FLAT_CASE_FRONT_ML: Internal.KeyZone;
        static readonly CASE_ZONES_L: Internal.KeyZone[];
        static readonly CASE_ZONES: Internal.KeyZone[];
        static readonly SCREEN_KEYS: Internal.KeyZone;
        static readonly FLAT_CASE_LEFT: Internal.KeyZone;
        static readonly CASE_LEFT: Internal.KeyZone;
        static readonly FLAT_CASE_FRONT_MR: Internal.KeyZone;
        static readonly FLAT_CASE_FRONT_FL: Internal.KeyZone;
        static readonly CASE_MID_LEFT: Internal.KeyZone;
        static readonly GRAVE_KEY: Internal.KeyZone;
        static readonly FLAT_CASE_FRONT_FR: Internal.KeyZone;
        static readonly BACK_KEY: Internal.KeyZone;
        static readonly WASD_KEYS: Internal.KeyZone;
        static readonly UTIL_ZONES: Internal.KeyZone[];
        static readonly FLAT_CASE_BACK_ML: Internal.KeyZone;
        static readonly CASE_RIGHT: Internal.KeyZone;
        static readonly BACKSLASH_KEY: Internal.KeyZone;
        static readonly FLAT_CASE_RIGHT: Internal.KeyZone;
        static readonly CASE_ZONES_R: Internal.KeyZone[];
        static readonly FLAT_CASE_BACK_MR: Internal.KeyZone;
        static readonly MODIFIER_KEYS_LEFT: Internal.KeyZone;
        static readonly MODIFIER_KEYS_RIGHT: Internal.KeyZone;
        static readonly TOP_SIDE_KEYS: Internal.KeyZone;
        static readonly FLAT_CASE_BACK_FL: Internal.KeyZone;
        static readonly ESC_KEY: Internal.KeyZone;
        static readonly ARROW_KEYS: Internal.KeyZone;
        static readonly CASE_MID_RIGHT: Internal.KeyZone;
        static readonly FLAT_CASE_BACK_FR: Internal.KeyZone;
        static readonly CASE_ZONES_M: Internal.KeyZone[];
        static readonly CAPS_KEY: Internal.KeyZone;
        static readonly LSHIFT: Internal.KeyZone;
        static readonly FN_ZONES: Internal.KeyZone[];
        static readonly TAB_KEY: Internal.KeyZone;
    }
    type KeyZone_ = "num_row" | "flat_case_front_ml" | "top_side_keys" | "back_key" | "flat_case_right" | "modifier_keys_right" | "arrow_keys" | "backslash_key" | "right_fn_keys" | "case_mid_left" | "enter_key" | "lshift" | "wasd_keys" | "case_left" | "flat_case_back_mr" | "grave_key" | "mid_side_keys" | "modifier_keys_left" | "flat_case_back_ml" | "rshift" | KeyZone | "tab_key" | "most_keys" | "screen_keys" | "flat_case_front_fr" | "space_key" | "case_right" | "caps_key" | "mid_fn_keys" | "flat_case_front_mr" | "esc_key" | "flat_case_back_fr" | "case_mid_right" | "flat_case_left" | "left_fn_keys" | "flat_case_front_fl" | "flat_case_back_fl";
    class AnimatableManager <T extends Internal.GeoAnimatable> {
        constructor(animatable: Internal.GeoAnimatable_)
        tryTriggerAnimation(controllerName: string, animName: string): void;
        getFirstTickTime(): number;
        updatedAt(updateTime: number): void;
        getAnimationControllers(): Internal.Map<string, Internal.AnimationController<T>>;
        getLastUpdateTime(): number;
        isFirstTick(): boolean;
        getData<D>(dataTicket: Internal.DataTicket_<D>): D;
        stopTriggeredAnimation(animName: string): void;
        startedAt(time: number): void;
        clearSnapshotCache(): void;
        addController(controller: Internal.AnimationController_<any>): void;
        removeController(name: string): void;
        setData<D>(dataTicket: Internal.DataTicket_<D>, data: D): void;
        getBoneSnapshotCollection(): Internal.Map<string, Internal.BoneSnapshot>;
        tryTriggerAnimation(animName: string): void;
        stopTriggeredAnimation(controllerName: string, animName: string): void;
        get firstTickTime(): number
        get animationControllers(): Internal.Map<string, Internal.AnimationController<T>>
        get lastUpdateTime(): number
        get firstTick(): boolean
        get boneSnapshotCollection(): Internal.Map<string, Internal.BoneSnapshot>
    }
    type AnimatableManager_<T extends Internal.GeoAnimatable> = AnimatableManager<T>;
    class VillagerProfessionBuilder extends Internal.BuilderBase<Internal.VillagerProfession> {
        constructor(i: ResourceLocation_)
        workSound(t: Internal.SoundEvent_): this;
        poiTypeTag(t: ResourceLocation_): this;
        poiType(t: ResourceLocation_): this;
        createObject(): any;
        secondaryPoi(t: Internal.Block_[]): this;
        requestedItems(t: Internal.Item_[]): this;
    }
    type VillagerProfessionBuilder_ = VillagerProfessionBuilder;
    interface DoubleStream$DoubleMapMultiConsumer {
        abstract accept(arg0: number, arg1: Internal.DoubleConsumer_): void;
        (arg0: number, arg1: Internal.DoubleConsumer): void;
    }
    type DoubleStream$DoubleMapMultiConsumer_ = DoubleStream$DoubleMapMultiConsumer;
    abstract class AbstractGolem extends Internal.PathfinderMob {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AbstractGolem_ = AbstractGolem;
    class TooltipItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TooltipItem_ = TooltipItem;
    class Tadpole extends Internal.AbstractFish {
        constructor($$0: Internal.EntityType_<Internal.AbstractFish>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        method_5992($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        /**
         * @deprecated
        */
        static loadDefaultDataFromBucketTag($$0: Internal.Mob_, $$1: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getBrain(): Internal.Brain<Internal.Tadpole>;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getTicksLeftUntilAdult(): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        /**
         * @deprecated
        */
        static saveDefaultDataToBucketTag($$0: Internal.Mob_, $$1: Internal.ItemStack_): void;
        getScriptType(): Internal.ScriptType;
        static bucketMobPickup<T extends Internal.LivingEntity & Internal.Bucketable>($$0: Internal.Player_, $$1: Internal.InteractionHand_, $$2: T): Internal.Optional<Internal.InteractionResult>;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get brain(): Internal.Brain<Internal.Tadpole>
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        get ticksLeftUntilAdult(): number
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static HITBOX_WIDTH: 0.4;
        static ticksToBeFrog: 24000;
        static HITBOX_HEIGHT: 0.3;
    }
    type Tadpole_ = Tadpole;
    class QuickPlayLog$Type extends Internal.Enum<Internal.QuickPlayLog$Type> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.QuickPlayLog$Type;
        getSerializedName(): string;
        static values(): Internal.QuickPlayLog$Type[];
        get serializedName(): string
        static readonly MULTIPLAYER: Internal.QuickPlayLog$Type;
        static readonly SINGLEPLAYER: Internal.QuickPlayLog$Type;
        static readonly REALMS: Internal.QuickPlayLog$Type;
    }
    type QuickPlayLog$Type_ = QuickPlayLog$Type | "multiplayer" | "realms" | "singleplayer";
    interface BlockApiLookup <A, C> {
        abstract getProvider(arg0: Internal.Block_): Internal.BlockApiLookup$BlockApiProvider<A, C>;
        registerForBlockEntity<T extends Internal.BlockEntity>(provider: Internal.BiFunction_<T, C, A>, blockEntityType: Internal.BlockEntityType_<T>): void;
        abstract registerSelf(...arg0: Internal.BlockEntityType_<any>[]): void;
        get<A, C>(lookupId: ResourceLocation_, apiClass: A, contextClass: C): this;
        abstract getId(): ResourceLocation;
        abstract contextClass(): C;
        abstract registerFallback(arg0: Internal.BlockApiLookup$BlockApiProvider_<A, C>): void;
        abstract find(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockEntity_, arg4: C): A;
        abstract apiClass(): A;
        abstract registerForBlockEntities(arg0: Internal.BlockApiLookup$BlockEntityApiProvider_<A, C>, ...arg1: Internal.BlockEntityType_<any>[]): void;
        find(world: Internal.Level_, pos: BlockPos_, context: C): A;
        abstract registerForBlocks(arg0: Internal.BlockApiLookup$BlockApiProvider_<A, C>, ...arg1: Internal.Block_[]): void;
        get id(): ResourceLocation
    }
    type BlockApiLookup_<A, C> = BlockApiLookup<A, C>;
    class OverslimeModifierRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.OverslimeModifierRecipe> {
        constructor()
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.OverslimeModifierRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
    }
    type OverslimeModifierRecipe$Serializer_ = OverslimeModifierRecipe$Serializer;
    interface Lock {
        abstract lock(): void;
        abstract unlock(): void;
        abstract tryLock(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract tryLock(): boolean;
        abstract lockInterruptibly(): void;
        abstract newCondition(): Internal.Condition;
    }
    type Lock_ = Lock;
    class Size extends Internal.Record {
        constructor(width: number, height: number)
        static zero(): Internal.Size;
        static square(sideLength: number): Internal.Size;
        width(): number;
        height(): number;
        static of(width: number, height: number): Internal.Size;
    }
    type Size_ = Size;
    interface IMolecularAssemblerSupportedPattern extends Internal.IPatternDetails {
        abstract fillCraftingGrid(arg0: Internal.KeyCounter_[], arg1: Internal.IMolecularAssemblerSupportedPattern$CraftingGridAccessor_): void;
        pushInputsToExternalInventory(inputHolder: Internal.KeyCounter_[], inputSink: Internal.IPatternDetails$PatternInputSink_): void;
        abstract getDefinition(): Internal.AEItemKey;
        abstract isSlotEnabled(arg0: number): boolean;
        getPrimaryOutput(): Internal.GenericStack;
        abstract getInputs(): any[];
        supportsPushInputsToExternalInventory(): boolean;
        abstract isItemValid(arg0: number, arg1: Internal.AEItemKey_, arg2: Internal.Level_): boolean;
        abstract getRemainingItems(arg0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        abstract assemble(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): Internal.ItemStack;
        abstract getOutputs(): Internal.GenericStack[];
        get definition(): Internal.AEItemKey
        get primaryOutput(): Internal.GenericStack
        get inputs(): any[]
        get outputs(): Internal.GenericStack[]
    }
    type IMolecularAssemblerSupportedPattern_ = IMolecularAssemblerSupportedPattern;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor {
    interface EntityAccessor {
        abstract port_lib$getEntityString(): string;
        port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        abstract port_lib$setRemovalReason(arg0: Internal.Entity$RemovalReason_): void;
    }
    type EntityAccessor_ = EntityAccessor;
    interface BucketItemAccessor {
        abstract port_lib$getContent(): Internal.Fluid;
        (): Internal.Fluid_;
    }
    type BucketItemAccessor_ = BucketItemAccessor;
}
